 ; Ŀ
 ;   Cat - find loose attributes and replace them with text.               
 ;   Copyright 1991, 2009 by Rocket Software Ltd.                          
 ;   The next revision will shed and leave dead mice in your shoes.        
 ; 

 ; Ŀ
 ;   Subroutine Chat - duplicate an attribute with a text entity.          
 ; 
 (DEFUN CHAT (enam / conv tt fh bb nn elast bbf sublst asonum)
  (setq conv 0)
  (setq tt (getvar "textstyle"))                         ; current text style
  (setq fh (cdr (assoc 40 (tblsearch "style" tt))))      ; is it fixed height?
  (setq bb (entget enam))
  (setq nn 2)
  (if (= fh 0.0)                                         ; fixed height?
      (command "text" (getvar "viewctr") "" "" ".")      ; no
      (command "text" (getvar "viewctr") "" "."))        ; yes
  (setq elast (entget (entlast)))
  (setq bbf (list (nth 1 elast) (nth 0 elast)))
  (while (setq sublst (nth nn bb))
         (setq asonum (car sublst))
         (cond ((not (or (= 1 asonum)
                         (= 2 asonum)
                         (= 3 asonum)
                         (= 5 asonum)
                         (= 70 asonum)
                         (= 73 asonum)
                         (= 74 asonum)
                         (= 280 asonum)))
                (setq bbf (cons sublst bbf)))
               ((= 2 asonum)
                (setq bbf (cons (cons 1 (cdr sublst)) bbf)))
               ((= 74 asonum)
                (setq bbf (cons (cons 73 (cdr sublst)) bbf))))
         (setq nn (1+ nn)))
  (setq bbf (reverse bbf))
  (entmod bbf)
 (princ))
 ; Ŀ
 ;   Chat end.                                                             
 ; 

 ; Ŀ
 ;   Cat - the domesticated predator.                                      
 ; 
 (DEFUN C:CAT (/ ss conv rad enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq ss (ssget "X" (list (cons 0 "ATTDEF"))))
  (if ss
     (progn
          (setq conv (sslength ss))
          (setq rad (getdist (getvar "viewctr")
                                     "Marker length (<Return> for preset): "))
          (if (null rad)
                    (setq rad (/ (- (car (getvar "extmax"))
                                    (car (getvar "extmin"))) 25)))
          (while (setq enam (ssname ss 0))
                 (setq pa (cdr (assoc 10 (entget enam))))
                 (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
                 (grdraw (polar pa (* pi 0.75) rad)
                                   (polar pa (* pi 1.75) rad) 7)
                 (chat enam)
                 (entdel enam)
                 (ssdel enam ss)
                 (redraw (entlast)))
 ; Ŀ
 ;   Print summary of actions.                                             
 ; 
          (if (> conv 1)
              (prompt (strcat "\n" (itoa conv) " attributes converted."))
              (prompt (strcat "\n1 attribute converted."))))
     (prompt "This drawing appears relatively attribute free."))   
  (command "undo" "end")
 (princ))